const int lightPin = A0;         // Photoresistor connected to analog pin A0
const int buttonPin = 2;         // Button is connected to digital pin 2
const int buzzerPin = 8;         // Buzzer connected to digital pin 8

int melodyLength = 0;
int noteIndex = 0;

// Frequencies of each note of the melody
int melody[] = {
  330, 370, 494, 554,  // E4, F#4, B4, C#5
  587, 370, 330, 554,  // D5, F#4, E4, C#5
  494, 370, 587, 554   // B4, F#4, D5, C#5
};

void setup() {
  pinMode(lightPin, INPUT);
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(buzzerPin, OUTPUT);

  // We'll be plotting the light level
  Serial.begin(9600);  // Start serial communication at 9600 baud

  // Store the length of the melody (we'll need it later)
  melodyLength = sizeof(melody) / sizeof(melody[0]);
}

void loop() {
  // Only play tones when the button is pressed
  if (digitalRead(buttonPin) == LOW) {      // Button pressed
    int lightLevel = analogRead(lightPin);  // Read the light level (0-1023)
    Serial.println(lightLevel);             // Print out the light level
    playNote(lightLevel);                   // Pass light value to control note speed
  } else {
    noTone(buzzerPin);
  }
}

// We're playing here note-by-note, since we want changes in light level to have a direct effect
// on the next note we're playing, and not have to wait until the melody restarts.
void playNote(int lightLevel) {
  // Map the light value (0-1023) to a note length range (50-400 ms)
  int noteLength = map(lightLevel, 0, 1023, 20, 500);
  int playDuration = noteLength * 0.4;
  int pauseDuration = noteLength * 0.6;

  tone(buzzerPin, melody[noteIndex]);  // Play the note
  delay(playDuration);                 // Wait for the note to finish
  noTone(buzzerPin);                   // Stop the tone
  delay(pauseDuration);                // Short pause between notes

  // Go to the next note
  noteIndex += 1;
  // If our index would be larger than the amount of notes, reset
  if (noteIndex >= melodyLength) {
    noteIndex = 0;
  }
}