const int lightPin = A0;  // Photoresistor connected to analog pin A0
const int buttonPin = 2; // Button is connected to digital pin 2
const int buzzerPin = 8;  // Buzzer connected to digital pin 8

void setup() {
  pinMode(lightPin, INPUT);
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(buzzerPin, OUTPUT);

  // We'll be plotting the light level and frequency
  Serial.begin(9600);  // Start serial communication at 9600 baud
}

void loop() {
  // Only play tones when the button is pressed
  if (digitalRead(buttonPin) == LOW) {      // Button pressed
    int lightLevel = analogRead(lightPin);  // Read the light level (0-1023)
    Serial.print(lightLevel);               // Print the light level (use "print" instead of "println" to stay on the same line)
    Serial.print(", ");                     // Print a comma to separate the light level and frequency

    // Map the light value (0-1023) to a frequency range (200-1000 Hz)
    // Note that we invert the range: more light = higher frequency
    int frequency = map(lightLevel, 1023, 0, 200, 1000);
    Serial.println(frequency);  // Print the frequency (use "println" here to go to the next line);

    tone(buzzerPin, frequency);  // Play tone at the mapped frequency
  } else {
    // If button is released, don't play a tone
    noTone(buzzerPin);
  }
  delay(100);  // Short delay to allow the sound to be heard
}