const int buttonPin = 2; // Button connected to digital pin 2
const int buzzerPin = 8; // Buzzer connected to digital pin 8
const int noteLength = 130; // Duration of each note in milliseconds

// Frequencies of each note of the melody
// This is Steve Reich's "Piano Phase"
int melody[] = {
  330, 370, 494, 554,   // E4, F#4, B4, C#5
  587, 370, 330, 554,   // D5, F#4, E4, C#5
  494, 370, 587, 554    // B4, F#4, D5, C#5
};

void setup() {
    pinMode(buzzerPin, OUTPUT);
    pinMode(buttonPin, INPUT_PULLUP);
}

void loop() {
    if (digitalRead(buttonPin) == LOW) { // Button pressed
        playMelody();
    } else {
        noTone(buzzerPin);
    }
}

void playMelody() {
    // This calculates the length of the array
    int length = sizeof(melody) / sizeof(melody[0]);
    int playDuration = noteLength * 0.4;
    int pauseDuration = noteLength * 0.6;

    for (int i = 0; i < length; i++) {
        tone(buzzerPin, melody[i]); // Play the note
        delay(playDuration);        // Wait for the note to finish
        noTone(buzzerPin);          // Stop the tone
        delay(pauseDuration);       // Short pause between notes
    }
}