const int buttonPin = 2;
const int buzzerPin = 8;
const int stepDuration = 150; // Duration of each step in milliseconds

// Beat pattern: 1 = sound, 0 = silence
// This is Steve Reich's "Clapping Music" pattern
int beatPattern[] = {
  1, 1, 1, 0,   // Three claps, rest
  1, 1, 0, 1,   // Two claps, rest, one clap
  0, 1, 1, 0    // Rest, two claps, rest
};

void setup() {
    pinMode(buzzerPin, OUTPUT);
    pinMode(buttonPin, INPUT_PULLUP);
}

void loop() {
    if (digitalRead(buttonPin) == LOW) { // Button pressed
        playBeat();
    } else {
        noTone(buzzerPin);
    }
}

void playBeat() {
    int length = sizeof(beatPattern) / sizeof(beatPattern[0]);

    for (int i = 0; i < length; i++) {
        if (beatPattern[i] == 1) {
            tone(buzzerPin, 200); // Play a low tone for the beat
            delay(stepDuration * 0.5); // Sound for half the step
            noTone(buzzerPin);
            delay(stepDuration * 0.5); // Silence for the rest
        } else {
            noTone(buzzerPin);
            delay(stepDuration); // Full step of silence
        }
    }
}