const int buttonPin = 2;
const int buzzerPin = 8;

void setup() {
    pinMode(buzzerPin, OUTPUT);
    pinMode(buttonPin, INPUT_PULLUP);
    // Seed random number generator with noise from an unconnected pin
    randomSeed(analogRead(0));    
}

void loop() {
    if (digitalRead(buttonPin) == LOW) { // Button pressed
        playSiren();
    } else {
        noTone(buzzerPin);
    }
}

void playSiren() {
    // Play 20 random tones
    for (int i = 0; i < 20; i++) {
        int freq = random(200, 1000); // Random frequency between 200 and 1000 Hz
        tone(buzzerPin, freq);
        delay(50); // Short delay to allow the sound to be heard
    }
    noTone(buzzerPin); // Stop the tone after the loop
    delay(200); // Short pause before the next siren
}