const int buttonPin = 2;
const int buzzerPin = 8;

bool buzzerState = false; // Keep track of whether the buzzer is on or off
bool lastButtonState = HIGH; // Previous state of the button

void setup() {
    pinMode(buttonPin, INPUT_PULLUP);  // Internal resistor pulls pin HIGH
    pinMode(buzzerPin, OUTPUT);
}

void loop() {
    bool currentButtonState = digitalRead(buttonPin);

    // Check for button press (rising edge)
    if (lastButtonState == HIGH && currentButtonState == LOW) {
        buzzerState = !buzzerState; // Toggle buzzer state
    }

    // Update the buzzer based on its state
    if (buzzerState) {
        tone(buzzerPin, 440);  // Play A4 note (440 Hz)
    } else {
        noTone(buzzerPin);     // Silence
    }

    lastButtonState = currentButtonState; // Save the current state for next loop
}