const int buttonPin = 2;
const int ledPin = 13;

bool ledState = false;
bool lastButtonState = HIGH;

void setup() {
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  bool currentButtonState = digitalRead(buttonPin);
  
  // Detect button press (transition from HIGH to LOW)
  if (lastButtonState == HIGH && currentButtonState == LOW) {
    ledState = !ledState;  // Toggle state
    digitalWrite(ledPin, ledState);
    delay(50);  // Simple debounce
  }
  
  lastButtonState = currentButtonState;
}